/******************************************************************************************/
/**
  Copyright (c) 2006 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file         main_p1.c	
  \brief    	This file contains the execution of the emulated PWM functions \n
                as well as the handling of a multi-thread scheduler. 
  \author   	Freescale Semiconductor
  \author       R01160
  \author   	Guadalajara Applications Laboratory RTAC Americas
  \version      1.0
  \date     	
  
  * History:
  
*/
/******************************************************************************************/
#include "Derivative.h"
#include "Port.h"
#include "Pwm.h"
#include "Mcu.h"
#include "Tasks.h"
#include "Scheduler.h"

/** Enable Interrupts */
#define ENABLE_INTERRUPTS_Z0    INTC_CPR_PRC1_PRI = 0;  \
                                asm(" wrteei 1")	    
   

extern uint32_t EXCEPTION_HANDLERS_P1;   // defined in the LCF
extern const uint32_t IntcIsrVectorTable_p1[];
/* -- Functions ---------------------------------------------------------------*/
void initINTC(void);


void initINTC(void) 
{	
  INTC.MCR.B.HVEN_PRC1 = 0;   /* MPC551x PRC1: initialize for SW vector mode */
  INTC.MCR.B.VTES_PRC1 = 0;   /* MPC551x PRC1: default vector table 4B offsets*/
  INTC.IACKR_PRC1.R = (uint32_t) &IntcIsrVectorTable_p1[0]; /* MPC551x: ISR table base */
}

 
/* Load z0's IVPR from the value provided in the LCF */
asm void initIVPR_p1(void) 
{
  lis r0, EXCEPTION_HANDLERS_P1@ha
  ori r0, r0, EXCEPTION_HANDLERS_P1@l  
  mtivpr r0  
}


void main_p1(void) 
{
   
  /* Initialise Scheduler handling variables */
  gu8SleepModeEnabled = 0;
  gu8Scheduler_Ctrl   = 0;
  gu8Scheduler_Flag   = 0;
   
   
  /* Enable interrupts for Z0 core */
  initINTC();
  initIVPR_p1(); 
  /* Initialize Pwm module */
  vfnPwm_Init(Pwm_ChannelConfig);
  /* Configure eMios channel 0 for Scheduler operation */
  vfnScheduler_Init();
  /* Assign Core Interrupt Handling */
  vfnCoreInterruptHandling(0);
  /* Enable Global Interrupts       */
  ENABLE_INTERRUPTS_Z0;
  /* Run Scheduler Tasks            */
  vfnStart_Scheduler();
  /* Enable Pwm signal generation   */
  PWM_ENABLED;
  
 
   while (gu8SleepModeEnabled == 0)
   {
       if ((gu8Scheduler_Flag & (uint8_t)0x01) == (uint8_t)0x01)
        {
            /*-- Allow 100 ms periodic tasks to be executed --*/
            EXECUTE_100MS_TASKS(); 
	        /* Scheduled tasks finished, clear control flag */
            gu8Scheduler_Flag = (uint8_t)0x00;
        }
        else
        { 
            if ((gu8Scheduler_Flag & (uint8_t)0x02) == (uint8_t)0x02)
            {    
                /*-- Allow 200 ms periodic tasks to be executed --*/
                 EXECUTE_200MS_TASKS(); 
	       	    /* Scheduled tasks finished, clear control flag */
                 gu8Scheduler_Flag = (uint8_t)0x00;
            }
            else
            { 
                if ((gu8Scheduler_Flag & (uint8_t)0x04) == (uint8_t)0x04)
                {
                    /*-- Allow 400 ms periodic tasks to be executed --*/
                     EXECUTE_400MS_TASKS(); 
                    /* Scheduled tasks finished, clear control flag */
                    gu8Scheduler_Flag = (uint8_t)0x00;
                }
                else
                {     
                    if ((gu8Scheduler_Flag & (uint8_t)0x08) == (uint8_t)0x08)
                    {
                        /*-- Allow 800 ms group A periodic tasks to be executed --*/
                         EXECUTE_800MS_A_TASKS();
		            	/* Scheduled tasks finished, clear control flag */
                        gu8Scheduler_Flag = (uint8_t)0x00;
                    }
                    else
                    {     
                        if ((gu8Scheduler_Flag & (uint8_t)0x10) == (uint8_t)0x10)
                        {
                            /*-- Allow 800 ms group B periodic tasks to be executed --*/
			                
                            /* Scheduled tasks finished, clear control flag */
                            gu8Scheduler_Flag = (uint8_t)0x00;                 
                        }
                    }
                }
            }
        }   
   }
}


